/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;

public class CertificateUtil {
    private static final Logger logger = Logger.getLogger(CertificateUtil.class);

    public static X509Certificate[] getCertsFromChannel(Channel channel) {
        Certificate[] plainCerts = null;
        ChannelHandler channelHandler = channel.pipeline().get("ssl");
        if (channelHandler != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                plainCerts = sslHandler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        X509Certificate[] x509Certs = null;
        if (plainCerts != null && plainCerts.length > 0) {
            x509Certs = new X509Certificate[plainCerts.length];
            for (int i = 0; i < plainCerts.length; ++i) {
                if (plainCerts[i] instanceof X509Certificate) {
                    x509Certs[i] = (X509Certificate)plainCerts[i];
                } else {
                    try {
                        x509Certs[i] = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(plainCerts[i].getEncoded()));
                    }
                    catch (Exception ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Failed to convert SSL cert", ex);
                        }
                        return null;
                    }
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Cert #" + i + " = " + x509Certs[i]);
            }
        }
        return x509Certs;
    }
}

