/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FixedSizeBitSet;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class SeqnoList
extends FixedSizeBitSet
implements Streamable,
Iterable<Long> {
    protected long offset;

    public SeqnoList() {
    }

    public SeqnoList(int size, long offset) {
        super(size);
        this.offset = offset;
    }

    public SeqnoList(int size) {
        this(size, 0L);
    }

    public SeqnoList add(long seqno) {
        super.set(this.index(seqno));
        return this;
    }

    public SeqnoList add(long ... seqnos) {
        if (seqnos != null) {
            for (long seqno : seqnos) {
                this.add(seqno);
            }
        }
        return this;
    }

    public SeqnoList add(long from, long to) {
        super.set(this.index(from), this.index(to));
        return this;
    }

    public void removeHigherThan(long max_seqno) {
        int to;
        int from = this.index(max_seqno + 1L);
        if (from <= (to = this.size - 1) && from >= 0) {
            super.clear(from, to);
        }
    }

    public long getLast() {
        int index = this.previousSetBit(this.size - 1);
        return index == -1 ? -1L : this.seqno(index);
    }

    public int serializedSize() {
        return 4 + (this.words.length + 1) * 8;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeInt(this.size);
        out.writeLong(this.offset);
        for (long word : this.words) {
            out.writeLong(word);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.size = in.readInt();
        this.offset = in.readLong();
        this.words = new long[SeqnoList.wordIndex(this.size - 1) + 1];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = in.readLong();
        }
    }

    @Override
    public int size() {
        return super.cardinality();
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("(").append(this.cardinality()).append("): {");
        boolean first = true;
        int num = Util.MAX_LIST_PRINT_SIZE;
        int i = this.nextSetBit(0);
        while (i >= 0) {
            int endOfRun = this.nextClearBit(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (endOfRun != -1 && endOfRun - 1 != i) {
                sb.append(this.seqno(i)).append('-').append(this.seqno(endOfRun - 1));
                i = endOfRun;
            } else {
                sb.append(this.seqno(i));
            }
            if (--num <= 0) {
                sb.append(", ... ");
                break;
            }
            i = this.nextSetBit(i + 1);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Long> iterator() {
        return new SeqnoListIterator();
    }

    protected int index(long seqno) {
        return (int)(seqno - this.offset);
    }

    protected long seqno(int index) {
        return this.offset + (long)index;
    }

    protected class SeqnoListIterator
    implements Iterator<Long> {
        protected int index;

        protected SeqnoListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SeqnoList.this.size && SeqnoList.this.nextSetBit(this.index) != -1;
        }

        @Override
        public Long next() {
            int next_index = SeqnoList.this.nextSetBit(this.index);
            if (next_index == -1 || next_index >= SeqnoList.this.size) {
                throw new NoSuchElementException("index: " + next_index);
            }
            this.index = next_index + 1;
            return SeqnoList.this.seqno(next_index);
        }

        @Override
        public void remove() {
        }
    }
}

