/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class ModClusterAdvertizeListener {
    public static void main(String[] args) {
        InetAddress bind_addr = null;
        InetAddress mcast_addr = null;
        byte[] buf = null;
        int port = 23364;
        boolean receive_on_all_interfaces = true;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if ("-help".equals(tmp)) {
                    ModClusterAdvertizeListener.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-receive_on_all_interfaces".equals(args[i])) {
                    receive_on_all_interfaces = true;
                    continue;
                }
                ModClusterAdvertizeListener.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.1.105");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock = new MulticastSocket(port);
            InetSocketAddress join_addr = new InetSocketAddress(mcast_addr, port);
            if (receive_on_all_interfaces) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    sock.joinGroup(join_addr, intf);
                    System.out.println("joined " + join_addr + " on " + intf.getName());
                }
            } else {
                if (bind_addr != null) {
                    sock.setInterface(bind_addr);
                }
                sock.joinGroup(join_addr, null);
            }
            System.out.println("Socket=" + sock.getLocalAddress() + ':' + sock.getLocalPort() + ", bind interface=" + sock.getInterface());
            while (true) {
                buf = new byte[256];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                sock.receive(packet);
                byte[] recv_buf = packet.getData();
                int length = packet.getLength();
                System.out.println(new String(recv_buf, 0, length) + " [sender=" + packet.getAddress().getHostAddress() + ':' + packet.getPort() + "]\n");
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <port for multicast socket>] [-receive_on_all_interfaces]");
    }
}

