/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux;

import java.util.Collection;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Channel;
import org.apache.activemq.artemis.shaded.org.jgroups.MembershipListener;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.MessageListener;
import org.apache.activemq.artemis.shaded.org.jgroups.UpHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.GroupRequest;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.MessageDispatcher;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RequestOptions;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.RspFilter;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.MuxRequestCorrelator;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.MuxUpHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.Muxer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.mux.NoMuxHandlerRspFilter;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FutureListener;
import org.apache.activemq.artemis.shaded.org.jgroups.util.RspList;

public class MuxMessageDispatcher
extends MessageDispatcher {
    private final short scope_id;

    public MuxMessageDispatcher(short scopeId) {
        this.scope_id = scopeId;
    }

    public MuxMessageDispatcher(short scopeId, Channel channel, MessageListener messageListener, MembershipListener membershipListener, RequestHandler handler) {
        this(scopeId);
        this.setMessageListener(messageListener);
        this.setMembershipListener(membershipListener);
        this.setChannel(channel);
        this.setRequestHandler(handler);
        this.start();
    }

    private Muxer<UpHandler> getMuxer() {
        UpHandler handler = this.channel.getUpHandler();
        return handler != null && handler instanceof MuxUpHandler ? (MuxUpHandler)handler : null;
    }

    @Override
    protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address localAddr) {
        return new MuxRequestCorrelator(this.scope_id, transport, handler, localAddr);
    }

    @Override
    public void start() {
        super.start();
        Muxer<UpHandler> muxer = this.getMuxer();
        if (muxer != null) {
            muxer.add(this.scope_id, this.getProtocolAdapter());
        }
    }

    @Override
    public void stop() {
        Muxer<UpHandler> muxer = this.getMuxer();
        if (muxer != null) {
            muxer.remove(this.scope_id);
        }
        super.stop();
    }

    @Override
    protected <T> GroupRequest<T> cast(Collection<Address> dests, Message msg, RequestOptions options, boolean blockForResults, FutureListener<RspList<T>> listener) throws Exception {
        RspFilter filter = options.getRspFilter();
        return super.cast(dests, msg, options.setRspFilter(NoMuxHandlerRspFilter.createInstance(filter)), blockForResults, listener);
    }
}

