/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.auth.AuthToken;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class X509Token
extends AuthToken {
    public static final String KEYSTORE_TYPE = "keystore_type";
    public static final String KEYSTORE_PATH = "keystore_path";
    public static final String KEYSTORE_PASSWORD = "keystore_password";
    public static final String CERT_ALIAS = "cert_alias";
    public static final String CERT_PASSWORD = "cert_password";
    public static final String TOKEN_ATTR = "auth_value";
    public static final String CIPHER_TYPE = "cipher_type";
    private boolean valueSet = false;
    @Property
    protected String keystore_type = "JKS";
    @Property
    protected String cert_alias = null;
    @Property
    protected String keystore_path = null;
    @Property(exposeAsManagedAttribute=false)
    protected String auth_value = null;
    @Property
    protected String cipher_type = "RSA";
    private byte[] encryptedToken = null;
    private char[] cert_password = null;
    private char[] keystore_password = null;
    private Cipher cipher = null;
    private PrivateKey certPrivateKey = null;
    private X509Certificate certificate = null;

    @Property(name="cert_password", exposeAsManagedAttribute=false)
    public void setCertPassword(String pwd2) {
        this.cert_password = pwd2.toCharArray();
    }

    @Property(name="keystore_password", exposeAsManagedAttribute=false)
    public void setKeyStorePassword(String pwd2) {
        this.keystore_password = pwd2.toCharArray();
        if (this.cert_password == null) {
            this.cert_password = this.keystore_password;
        }
    }

    public X509Token encryptedToken(byte[] buf) {
        this.encryptedToken = buf;
        return this;
    }

    @Override
    public String getName() {
        return "org.apache.activemq.artemis.shaded.org.jgroups.auth.X509Token";
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        block10: {
            if (!this.valueSet) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(Util.getMessage("X509TokenNotSetupCorrectlyCheckTokenAttrs"));
                }
                return false;
            }
            if (token != null && token instanceof X509Token) {
                X509Token serverToken = (X509Token)token;
                if (!serverToken.valueSet) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(Util.getMessage("X509TokenReceivedTokenNotValid"));
                    }
                    return false;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("setting cipher to decrypt mode");
                    }
                    this.cipher.init(2, this.certPrivateKey);
                    String serverBytes = new String(this.cipher.doFinal(serverToken.encryptedToken));
                    if (serverBytes.equalsIgnoreCase(this.auth_value)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("X509 authentication passed");
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error(e.toString());
                }
            }
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("X509Token writeTo()");
        }
        Util.writeByteBuffer(this.encryptedToken, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("X509Token readFrom()");
        }
        this.encryptedToken = Util.readByteBuffer(in);
        this.valueSet = true;
    }

    @Override
    public int size() {
        return Util.size(this.encryptedToken);
    }

    public void setCertificate() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnrecoverableEntryException {
        KeyStore store = KeyStore.getInstance(this.keystore_type);
        InputStream inputStream = null;
        inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keystore_path);
        if (inputStream == null) {
            inputStream = new FileInputStream(this.keystore_path);
        }
        store.load(inputStream, this.keystore_password);
        this.cipher = Cipher.getInstance(this.cipher_type);
        this.certificate = (X509Certificate)store.getCertificate(this.cert_alias);
        if (this.log.isDebugEnabled()) {
            this.log.debug("certificate = " + this.certificate.toString());
        }
        this.cipher.init(1, this.certificate);
        this.encryptedToken = this.cipher.doFinal(this.auth_value.getBytes());
        if (this.log.isDebugEnabled()) {
            this.log.debug("encryptedToken = " + this.encryptedToken);
        }
        KeyStore.PrivateKeyEntry privateKey = (KeyStore.PrivateKeyEntry)store.getEntry(this.cert_alias, new KeyStore.PasswordProtection(this.cert_password));
        this.certPrivateKey = privateKey.getPrivateKey();
        this.valueSet = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("certPrivateKey = " + this.certPrivateKey.toString());
        }
    }
}

